@REM Copyright Versata Corp. 2002
@echo off
@setlocal
@pushd %~dp0
@echo -------------------------------------------------------------------------
@echo Current folder : %~dp0
@echo Current script : %~nx0

set THISFOLDER=%~dp0
set THISSCRIPT=%~nx0
set REPONAME=
set REPODIR=
set EARFILE=
set LOCALDTD=false
set COPYSOURCE=false

:custom_shift
  if /i "%1"=="" (goto start) else (
    if /i "%1"=="-repository" (set REPONAME=%2&shift) else (
      if /i "%1"=="-repository_dir" (set REPODIR=%2&shift) else (
        if /i "%1"=="-earfile" (set EARFILE=%2&shift) else (
          if /i "%1"=="-localdtd" (set LOCALDTD=true) else (
            if /i "%1"=="-copysource" (set COPYSOURCE=true)
          )
        )
      )
    )
  )
  shift
  goto custom_shift

:start
  set REPODIR=%REPODIR:"=%
  set REPODIR=%REPODIR:"=%
  set EARFILE=%EARFILE:"=%
  set EARFILE=%EARFILE:"=%
  if /i "%REPODIR%"=="=" (set REPODIR=)
  if /i "%REPODIR%"==":=" (set REPODIR=)
  if /i "%EARFILE%"=="=" (set EARFILE=)
  if /i "%EARFILE%"==":=" (set EARFILE=)
  call ws_ss_setcp.bat > _trash.txt&del _trash.txt
  set TEMPDIR=%VERSATA_HOME%\Temp
  if /i "%REPONAME%"=="" (call :usage&goto finish)
  if /i "%COPYSOURCE%"=="true" (
    if /i "%REPODIR%"=="" (
      @echo Error : You need to specify repository_dir.&call :usage&goto finish
    )
    if not exist "%REPODIR%" (
      @echo Error : Repository directory does not exist.&goto finish
    )
  )
  if /i "%EARFILE%"=="" (
    set EARFILE=%VERSATA_HOME%\VLSComponents\Classes\%REPONAME%_Deployed.ear
  )
  if not exist "%VERSATA_HOME%\VLSComponents\Classes\%REPONAME%.ear" (
    @echo Error : Repository EAR directory %REPONAME%.ear does not exist.&goto finish
  )
  if not exist "%TEMPDIR%"  (mkdir "%TEMPDIR%")
  if exist "%TEMPDIR%\_ear" (rmdir "%TEMPDIR%\_ear" /s /q)
  if exist "%TEMPDIR%\_war" (rmdir "%TEMPDIR%\_war" /s /q)
  @echo Running %THISSCRIPT%
  @echo   VERSATA_HOME=%VERSATA_HOME%
  @echo   Repository name : %REPONAME%
  @echo   Repository directory : %REPODIR%
  @echo   Output ear file : %EARFILE%
  @echo   Copy java source : %COPYSOURCE%
  @echo   Use Local Dtd : %LOCALDTD%
  call :create_ear
goto finish

:create_ear
  @echo -------------------------------------------------------------------------
  @echo Copying files from %REPONAME%.ear folder ...
  xcopy /s /f /e /r /c "%VERSATA_HOME%\VLSComponents\Classes\%REPONAME%.ear" "%TEMPDIR%\_ear\*.*"
  xcopy /s /f /e /r /c "%TEMPDIR%\_ear\%REPONAME%.war" "%TEMPDIR%\_war\*.*"
  rmdir "%TEMPDIR%\_ear\%REPONAME%.war" /s /q
  cd "%TEMPDIR%\_ear"
  @echo Copying files from %REPONAME%.ear folder ... (done)
  @echo -------------------------------------------------------------------------
  @echo Switching web.xml's dtd if necessary ...
  cd "%TEMPDIR%\_war"
  if /i "%LOCALDTD%"=="false" (
    call :replace_dtd web-app_2_2.dtd ".\WEB-INF\web.xml"
  )
  if exist .\WEB-INF\web.xml.connected (
    del .\WEB-INF\web.xml.connected
  )
  cd "%TEMPDIR%\_ear"
  @echo Switching web.xml's dtd if necessary ... (done)
  @echo -------------------------------------------------------------------------
  @echo Switching application.xml's dtd if necessary ...
  if /i "%LOCALDTD%"=="false" (
    call :replace_dtd application_1_2.dtd ".\META-INF\application.xml"
  )
  if exist .\META-INF\application.xml.connected (
    del .\META-INF\application.xml.connected
  )
  @echo Switching application.xml's dtd if necessary ... (done)
  @echo -------------------------------------------------------------------------
  @echo Switching ejb-jar.xml's dtd if necessary ...
  if /i "%LOCALDTD%"=="false" (
    if exist .\%REPONAME%.jar (
      jar -xvf .\%REPONAME%.jar META-INF/ejb-jar.xml
      if exist .\META-INF\ejb-jar.xml (
        call :replace_dtd ejb-jar_1_1.dtd ".\META-INF\ejb-jar.xml"
        jar -uvf .\%REPONAME%.jar META-INF/ejb-jar.xml
        if exist .\META-INF\ejb-jar.xml (
          del .\META-INF\ejb-jar.xml
        )
        if exist .\META-INF\ejb-jar.xml.connected (
          del .\META-INF\ejb-jar.xml.connected
        )
      )
    )
  )
  @echo Switching ejb-jar.xml's dtd if necessary ... (done)
  @echo -------------------------------------------------------------------------
  @echo Copying EJB source from %REPONAME% repository ...
  if /i "%COPYSOURCE%"=="true" (
    mkdir "%TEMPDIR%\_ear\_ejb"&cd "%TEMPDIR%\_ear\_ejb"
    jar -xvf ..\%REPONAME%.jar&jar -tf ..\%REPONAME%.jar > .\_ejb.filelist    
    call :copy_ejb_source
    del .\_ejb.filelist
    jar -cvMf0 ..\%REPONAME%.jar .
    cd "%TEMPDIR%\_ear"&rmdir "%TEMPDIR%\_ear\_ejb" /s /q
  )
  @echo Copying EJB source from %REPONAME% repository ... (done)
  @echo -------------------------------------------------------------------------
  @echo Copying WAR source from %REPONAME% repository ...
  if /i "%COPYSOURCE%"=="true" (
    cd "%TEMPDIR%\_war"
    dir /b /a-d /s *.class > .\_war.filelist
    call :copy_war_source
    del .\_war.filelist
    cd "%TEMPDIR%\_ear"
  )
  @echo Copying WAR source from %REPONAME% repository ... (done)
  @echo -------------------------------------------------------------------------
  @echo Creating %REPONAME%.war file ...
  cd "%TEMPDIR%\_war"
  jar -cvMf0 ..\_ear\%REPONAME%.war .
  cd "%TEMPDIR%\_ear"
  @echo Creating %REPONAME%.war file ... (done)
  @echo -------------------------------------------------------------------------
  @echo Creating %REPONAME%_Deployed.ear file ...
  jar -cvMf0 ..\%REPONAME%_Deployed.ear .
  copy ..\%REPONAME%_Deployed.ear "%EARFILE%"
  cd "%TEMPDIR%"
  rmdir .\_ear /s /q&rmdir .\_war /s /q
  @echo Creating %REPONAME%_Deployed.ear file ... (done)
  @echo -------------------------------------------------------------------------
goto end

:copy_ejb_source
  for /f "eol=; Tokens=* Delims=" %%i in ('type "%TEMPDIR%\_ear\_ejb\_ejb.filelist"') do call :parse_ejb_filelist "%%i"
goto end

:parse_ejb_filelist
  set LINE=%1
  set LINE=%LINE:"=%
  set PACKAGE=
  set FILE=
  set NAME=
  set EXT=
  for /f "tokens=1-2 delims=/" %%i in ('echo %LINE%') do set PACKAGE=%%i&set FILE=%%j
  for /f "tokens=1-2 delims=." %%k in ('echo %FILE%') do set NAME=%%k&set EXT=%%l
  if "%PACKAGE%"=="%REPONAME%" (
    if /i "%EXT%"=="class" (call :copy_ejb_file "%NAME%")
  )
goto end

:copy_ejb_file 
  set NAME=%1
  set NAME=%NAME:"=%
  set COPY=
  cd "%REPODIR%\Cache\VLS"
  for /f "Tokens=*" %%i in ('dir "%NAME%.java" /b /a-d /s') do if exist "%%i" (set COPY=%%i)
  cd "%REPODIR%\Source\VLS"
  for /f "Tokens=*" %%i in ('dir "%NAME%.java" /b /a-d /s') do if exist "%%i" (set COPY=%%i)
  cd "%TEMPDIR%\_ear\_ejb"
  if /i not "%COPY%"=="" (@echo copying from: "%COPY%"&copy "%COPY%" ".\%REPONAME%\%NAME%.java")
goto end

:copy_war_source
  for /f "eol=; Tokens=* Delims=" %%i in ('type "%TEMPDIR%\_war\_war.filelist"') do call :parse_war_filelist "%%i"
goto end

:parse_war_filelist
  set LINE=%1
  set LINE=%LINE:"=%
  set TOKEN1=
  set TOKEN2=
  set APPLICATION=
  set FILE=
  set NAME=
  set EXT=
  :RESOLVE
  for /f "tokens=1* delims=\" %%i in ('echo %LINE%') do set TOKEN1=%%i& set TOKEN2=%%j
  if /i "%TOKEN2%"=="" (set FILE=%TOKEN1%) else (set APPLICATION=%TOKEN1%&set LINE=%TOKEN2%& goto RESOLVE)
  for /f "tokens=1-2 delims=." %%k in ('echo %FILE%') do set NAME=%%k&set EXT=%%l
  call :copy_war_file "%APPLICATION%" "%NAME%"
goto end

:copy_war_file
  set APPLICATION=%1
  set APPLICATION=%APPLICATION:"=%
  set NAME=%2
  set NAME=%NAME:"=%
  set COPY=
  if exist "%REPODIR%\Cache\ClientApps\HTMLApps\%APPLICATION%.app\." (
    cd "%REPODIR%\Cache\ClientApps\HTMLApps\%APPLICATION%.app"
    for /f "Tokens=*" %%i in ('dir "%NAME%.java" /b /a-d /s') do if exist "%%i" (set COPY=%%i)
  )
  if exist "%REPODIR%\Source\ClientApps\HTMLApps\%APPLICATION%.app\." (
    cd "%REPODIR%\Source\ClientApps\HTMLApps\%APPLICATION%.app"
    for /f "Tokens=*" %%i in ('dir "%NAME%.java" /b /a-d /s') do if exist "%%i" (set COPY=%%i)
  )
  cd "%TEMPDIR%\_war"
  if /i not "%COPY%"=="" (@echo copying from: "%COPY%"&copy "%COPY%" ".\WEB-INF\classes\%REPONAME%\%APPLICATION%\%NAME%.java")
goto end

:replace_dtd
  set DTDFILE=%1
  set XMLFILE=%2
  set XMLFILE=%XMLFILE:"=%
  type "%XMLFILE%" | find /i "?xml" >"%XMLFILE%.connected"
  type "%THISFOLDER%wsEARDtds.lst" | find /i "%DTDFILE%" >>"%XMLFILE%.connected"
  type "%XMLFILE%" | find /i /v "%DTDFILE%" | find /i /v "?xml" >>"%XMLFILE%.connected"
  del "%XMLFILE%"
  copy "%XMLFILE%.connected" "%XMLFILE%"
  del "%XMLFILE%.connected"
goto end

:finish
  @popd
  @endlocal
goto end

:usage
  @echo Usage : wsEarCreate.bat
  @echo         -repository {repository name} [-earfile {output ear file}]
  @echo         [-copysource -repository_dir {repository directory}]
  @echo         [-localdtd]
  @echo Process aborted.
:end

